<article id="node-<?php print $node->nid; ?>" class="<?php print $classes; ?> clearfix"<?php print $attributes; ?>>

  <?php if ($title_prefix || $title_suffix || $display_submitted || !$page): ?>
  <header>
    <?php print render($title_prefix); ?>
    <?php if (!$page): ?>
      <h2<?php print $title_attributes; ?>><a href="<?php print $node_url; ?>"><?php print $title; ?></a></h2>
    <?php endif; ?>
    <?php print render($title_suffix); ?>

    
  </header>
  <?php endif; ?>

  <div class="content"<?php print $content_attributes; ?>>
    <?php
      // We hide the comments and links now so that we can render them later.
      hide($content['comments']);
      hide($content['links']);
      hide($content['field_tags']);
      print render($content);
    ?>
	<?php if ($display_submitted): ?>
      <div class="submitted">
		<div class="col-md-6 nopadding">
			<p>
			<?php print t("Data publikacji").': '; ?>
			<time >
			<?php $date = date("d.n.Y", $node->created); ?>
			<?php print $date; ?>
			</time>
			</p>
			<p>
			<?php print t("Ostatnia modyfikacja").': '; ?>
			<time >
			<?php $date = date("d.n.Y", $node->changed); ?>
			<?php print $date; ?>
			</time>
			</p>
		</div>
		<div class="col-md-6 nopadding text-right">
			<p>
			<?php print t("Autor").': '; ?>
			<?php $user = user_load($node->uid); ?>
            <?php $username=$user->name; ?>
			<?php print $username ?>
			</time>
			</p>
			<p>
			
			<?php 
			print t("Liczba odwiedzin").': ';
			$nodevisit=statistics_get($node->nid);
			print $nodevisit['totalcount'];
			?>
			</p>
		</div>
		<div class="clearfix"></div>
      </div>
    <?php endif; ?>
  </div>
    
    <?php if (($tags = render($content['field_tags'])) || ($links = render($content['links']))): ?>
    <footer>
    <?php //print render($content['field_tags']); ?>
    <?php //print render($content['links']); ?>
    </footer>
    <?php endif; ?> 

  <?php print render($content['comments']); ?>

</article>