<?php 

/**
 * Page alter.
 */
function szablon_pwd_t1_1_page_alter($page) {
	$mobileoptimized = array(
		'#type' => 'html_tag',
		'#tag' => 'meta',
		'#attributes' => array(
		'name' =>  'MobileOptimized',
		'content' =>  'width'
		)
	);
	$handheldfriendly = array(
		'#type' => 'html_tag',
		'#tag' => 'meta',
		'#attributes' => array(
		'name' =>  'HandheldFriendly',
		'content' =>  'true'
		)
	);
	$viewport = array(
		'#type' => 'html_tag',
		'#tag' => 'meta',
		'#attributes' => array(
		'name' =>  'viewport',
		'content' =>  'width=device-width, initial-scale=1'
		)
	);
	drupal_add_html_head($mobileoptimized, 'MobileOptimized');
	drupal_add_html_head($handheldfriendly, 'HandheldFriendly');
	drupal_add_html_head($viewport, 'viewport');
}

/**
 * Preprocess variables for html.tpl.php
 */
function szablon_pwd_t1_1_preprocess_html(&$variables) {
	/**
	 * Add IE8 Support
	 */
	drupal_add_css(path_to_theme() . '/css/ie8.css', array('group' => CSS_THEME, 'browsers' => array('IE' => '(lt IE 9)', '!IE' => FALSE), 'preprocess' => FALSE));
    drupal_add_css('https://fonts.googleapis.com/css?family=Lato:400,700,300&subset=latin,latin-ext', array('type' => 'external'));
	/**
	* Bootstrap CDN
	*/
    
    if (theme_get_setting('bootstrap_css_cdn', 'szablon_pwd_t1_1')) {
        $cdn = '//maxcdn.bootstrapcdn.com/bootstrap/' . theme_get_setting('bootstrap_css_cdn', 'szablon_pwd_t1_1')  . '/css/bootstrap.min.css';
        drupal_add_css($cdn, array('type' => 'external'));
    }
    
    if (theme_get_setting('bootstrap_js_cdn', 'szablon_pwd_t1_1')) {
        $cdn = '//maxcdn.bootstrapcdn.com/bootstrap/' . theme_get_setting('bootstrap_js_cdn', 'szablon_pwd_t1_1')  . '/js/bootstrap.min.js';
        drupal_add_js($cdn, array('type' => 'external'));
    }
	
	$cdn = base_path() . drupal_get_path('theme', 'szablon_pwd_t1_1') . '/js/js.cookie.js';
        drupal_add_js($cdn, array('type' => 'external'));
	
	/**
	* Add Javascript for enable/disable scrollTop action
	*/
	if (theme_get_setting('scrolltop_display', 'szablon_pwd_t1_1')) {

		drupal_add_js('jQuery(document).ready(function($) { 
		$(window).scroll(function() {
			if($(this).scrollTop() != 0) {
				$("#toTop").fadeIn();	
			} else {
				$("#toTop").fadeOut();
			}
		});
		
		$("#toTop").click(function() {
			$("body,html").animate({scrollTop:0},800);
		});	
		
		});',
		array('type' => 'inline', 'scope' => 'header'));
	}
	//EOF:Javascript
}

/**
 * Override or insert variables into the html template.
 */
function szablon_pwd_t1_1_process_html(&$vars) {
	// Hook into color.module
	if (module_exists('color')) {
	_color_html_alter($vars);
	}
}



/**
 * Preprocess variables for page template.
 */
function szablon_pwd_t1_1_preprocess_page(&$vars) {

	/**
	 * insert variables into page template.
	 */
	if ($vars['page']['sidebar_first']) {
		$vars['sidebar_grid_class'] = 'col-md-3';
		$vars['main_grid_class'] = 'col-md-9';		
	} else {
		$vars['main_grid_class'] = 'col-md-12';			
	}
	
	$vars['logo_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t1_1') . '/images/local/logo.png';
  $vars['banner_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t1_1') . '/images/local/banner.png';
  $bannervar = array(
    'path' => $vars['banner_img'],
    'alt' => 'banner',
    'title' => 'banner',
    'attributes' => array('class' => 'img-responsive'),
  );
  $vars['banner'] = theme('image', $bannervar);
  
  $logovar = array(
    'path' => $vars['logo_img'],
    'alt' => 'logo',
    'title' => 'logo',
    'attributes' => array('class' => ''),
  );
  $vars['logo'] = theme('image', $logovar);
  
  $vars['foot1'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t1_1') . '/images/local/dolina-gubra-logo-stopka.svg';
  $vars['foot2'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t1_1') . '/images/local/maic.png';
  
  $vars['pwdlogo_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t1_1') . '/images/local/pwdlogo.jpg';
  
  $pwdlogovar = array(
    'path' => $vars['pwdlogo_img'],
    'alt' => 'banner',
    'title' => 'banner',
    'attributes' => array('class' => 'img-responsive'),
  );
  
  $vars['pwdlogo'] = theme('image', $pwdlogovar);



	/**
	 * Add Javascript
	 */
	
	//EOF:Javascript
}

/**
 * Override or insert variables into the page template.
 */
function szablon_pwd_t1_1_process_page(&$variables) {
  // Hook into color.module.
  if (module_exists('color')) {
    _color_page_alter($variables);
  }
}

function szablon_pwd_t1_1_js_alter(&$js)
{
    $jqKey = "my-new-jquery"; // a key for new jquery file entry
    $js[$jqKey] = $js['misc/jquery.js']; // copy the default jquery settings, so you don't have to re-type them.
    $js[$jqKey]['data'] = "https://code.jquery.com/jquery-2.1.0.min.js"; // the path for new jquery file.
    $js[$jqKey]['version'] = '2.1.0'; // your jquery version.

    unset($js['misc/jquery.js']); // delete drupal's default jquery file.
}

/**
 * Preprocess variables for block.tpl.php
 */
function szablon_pwd_t1_1_preprocess_block(&$variables) {
	$variables['classes_array'][]='clearfix';
}

/**
 * Override theme_breadrumb().
 *
 * Print breadcrumbs as a list, with separators.
 */
function szablon_pwd_t1_1_breadcrumb($variables) {
	$breadcrumb = $variables['breadcrumb'];

	if (!empty($breadcrumb)) {
		$breadcrumb[] = drupal_get_title();
		$breadcrumbs = '<ol class="breadcrumb">'. t('You are here').': ';

		$count = count($breadcrumb) - 1;
		foreach ($breadcrumb as $key => $value) {
		$breadcrumbs .= '<li>' . $value . '</li>';
		}
		$breadcrumbs .= '</ol>';

		return $breadcrumbs;
	}
}



/**
 * Search block form alter.
 */
function szablon_pwd_t1_1_form_alter(&$form, &$form_state, $form_id) {
	if ($form_id == 'search_block_form') {
	    unset($form['search_block_form']['#title']);
	    $form['search_block_form']['#title_display'] = 'invisible';
		$form_default = t('Search this website...');
	    $form['search_block_form']['#default_value'] = $form_default;

		$form['actions']['submit']['#attributes']['value'][] = '';

	 	$form['search_block_form']['#attributes'] = array('onblur' => "if (this.value == '') {this.value = '{$form_default}';}", 'onfocus' => "if (this.value == '{$form_default}') {this.value = '';}" );
	}
}
