<?php
/**
 * @file
 * Contains theme override functions and preprocess functions for the theme.
 */

/**
 * Implements hook_html_head_alter().
 */
function szablon_pwd_t3_1_html_head_alter(&$head_elements) {
  $head_elements['system_meta_content_type']['#attributes'] = array(
    'charset' => 'utf-8',
  );
}

function szablon_pwd_t3_1_js_alter(&$js)
{
    $jqKey = "my-new-jquery"; // a key for new jquery file entry
    $js[$jqKey] = $js['misc/jquery.js']; // copy the default jquery settings, so you don't have to re-type them.
    $js[$jqKey]['data'] = "https://code.jquery.com/jquery-2.1.0.min.js"; // the path for new jquery file.
    $js[$jqKey]['version'] = '2.1.0'; // your jquery version.

    unset($js['misc/jquery.js']); // delete drupal's default jquery file.
}

/**
 * Insert themed breadcrumb page navigation at top of the node content.
 */
function szablon_pwd_t3_1_breadcrumb($variables) {
  $breadcrumb = $variables['breadcrumb'];
  if (!empty($breadcrumb)) {
    // Use CSS to hide titile .element-invisible.
    $output = '<h2 class="element-invisible">' . t('You are here') . '</h2>';
    // Comment below line to hide current page to breadcrumb.
    $breadcrumb[] = drupal_get_title();
    $output .= '<div class="breadcrumb">' . implode(' » ', $breadcrumb) . '</div>';
    return $output;
  }
}

/**
 * Add javascript files for front-page jquery slideshow.
 */
if (drupal_is_front_page()) {
  drupal_add_js(drupal_get_path('theme', 'szablon_pwd_t3_1') . '/js/jquery.bxslider.js');
}

$cdn = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/js/js.cookie.js';
        drupal_add_js($cdn, array('type' => 'external'));
	

/**
 Dodawanie bootstrap.js i pwd.js
*/
drupal_add_js(drupal_get_path('theme', 'szablon_pwd_t3_1') . '/js/bootstrap.js');
drupal_add_js(drupal_get_path('theme', 'szablon_pwd_t3_1') . '/js/pwd.js');

/**
 * Add Google Fonts.
 */
function szablon_pwd_t3_1_preprocess_html(&$variables) {
  drupal_add_css('http://fonts.googleapis.com/css?family=Open+Sans', array('type' => 'external'));
  drupal_add_css('http://fonts.googleapis.com/css?family=Roboto&subset=latin,latin-ext', array('type' => 'external'));
  drupal_add_css('https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css', array('type' => 'external'));
}

// Overiders the default menu tree lists function
function szablon_pwd_t3_1_menu_tree__main_menu($variables) {

  return '<ul class="nav navbar-nav">' . $variables['tree'] . '</ul>';
}

/**
 * Override or insert variables into the page template.
 */
function szablon_pwd_t3_1_preprocess_page(&$vars) {
  $vars['twitter'] = theme_get_setting('twitter', 'szablon_pwd_t3_1');
  $vars['facebook'] = theme_get_setting('facebook', 'szablon_pwd_t3_1');
  $vars['linkedin'] = theme_get_setting('linkedin', 'szablon_pwd_t3_1');
  $vars['theme_path_social'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1');
  $vars['display'] = theme_get_setting('display', 'szablon_pwd_t3_1');
  $vars['footer_copyright'] = theme_get_setting('footer_copyright');
  $vars['footer_developed'] = theme_get_setting('footer_developed');
  $vars['footer_developedby_url'] = filter_xss_admin(theme_get_setting('footer_developedby_url', 'szablon_pwd_t3_1'));
  $vars['footer_developedby'] = filter_xss_admin(theme_get_setting('footer_developedby', 'szablon_pwd_t3_1'));
  $vars['searchblock'] = module_invoke('search', 'block_view', 'form');
  if (module_exists('i18n_menu')) {
    $vars['main_menu_tree'] = i18n_menu_translated_tree(variable_get('menu_main_links_source', 'main-menu'));
  }
  else {
    $vars['main_menu_tree'] = menu_tree(variable_get('menu_main_links_source', 'main-menu'));
  }
  // Frontpage variables.
  $vars['slideshow_display'] = theme_get_setting('slideshow_display', 'szablon_pwd_t3_1');
  $vars['slide1_title'] = theme_get_setting('slide1_title', 'szablon_pwd_t3_1');
  $vars['slide2_title'] = theme_get_setting('slide2_title', 'szablon_pwd_t3_1');
  $vars['slide3_title'] = theme_get_setting('slide3_title', 'szablon_pwd_t3_1');
  $vars['slide1_desc'] = theme_get_setting('slide1_desc', 'szablon_pwd_t3_1');
  $vars['slide2_desc'] = theme_get_setting('slide2_desc', 'szablon_pwd_t3_1');
  $vars['slide3_desc'] = theme_get_setting('slide3_desc', 'szablon_pwd_t3_1');
  
  $vars['slider_dis'] = theme_get_setting('slider_dis', 'szablon_pwd_t3_1');
  $vars['column_dis'] = theme_get_setting('column_dis', 'szablon_pwd_t3_1');
  
  $vars['link1_href'] = theme_get_setting('link1_href', 'szablon_pwd_t3_1');
  $vars['link2_href'] = theme_get_setting('link2_href', 'szablon_pwd_t3_1');
  $vars['link3_href'] = theme_get_setting('link3_href', 'szablon_pwd_t3_1');
  $vars['link4_href'] = theme_get_setting('link4_href', 'szablon_pwd_t3_1');
  $vars['link4_title'] = theme_get_setting('link4_title', 'szablon_pwd_t3_1');
  $vars['link4_desc'] = theme_get_setting('link4_desc', 'szablon_pwd_t3_1');
  $vars['link5_href'] = theme_get_setting('link5_href', 'szablon_pwd_t3_1');
  $vars['link5_title'] = theme_get_setting('link5_title', 'szablon_pwd_t3_1');
  $vars['link5_desc'] = theme_get_setting('link5_desc', 'szablon_pwd_t3_1');
  
  $vars['pwdlogo_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/pwdlogo.jpg';
  
  $pwdlogovar = array(
    'path' => $vars['pwdlogo_img'],
    'alt' => 'banner',
    'title' => 'banner',
    'attributes' => array('class' => 'img-responsive'),
  );
  
  $vars['pwdlogo'] = theme('image', $pwdlogovar);
 
  
  $vars['wtitle'] = filter_xss_admin(theme_get_setting('welcome_title', 'szablon_pwd_t3_1'));
  $vars['wtext'] = filter_xss_admin(theme_get_setting('welcome_text', 'szablon_pwd_t3_1'));
  $vars['col1'] = filter_xss_admin(theme_get_setting('colone', 'szablon_pwd_t3_1'));
  $vars['col1title'] = filter_xss_admin(theme_get_setting('colonetitle', 'szablon_pwd_t3_1'));
  $vars['col2'] = filter_xss_admin(theme_get_setting('coltwo', 'szablon_pwd_t3_1'));
  $vars['col2title'] = filter_xss_admin(theme_get_setting('coltwotitle', 'szablon_pwd_t3_1'));
  $vars['col3'] = filter_xss_admin(theme_get_setting('colthree', 'szablon_pwd_t3_1'));
  $vars['col3title'] = filter_xss_admin(theme_get_setting('colthreetitle', 'szablon_pwd_t3_1'));
  $vars['img1'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/slideshow/slide-image-1.jpg';
  $vars['img2'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/slideshow/slide-image-2.jpg';
  $vars['img3'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/slideshow/slide-image-3.jpg';
  
  $vars['link1_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/links/link1.png';
  $vars['link2_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/links/link2.png';
  $vars['link3_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/links/link3.png';
  $vars['link4_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/links/link4.png';
  $vars['link5_img'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/links/link5.png';
  $vars['foot1'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/dolina-gubra-logo-stopka.svg';
  $vars['foot2'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/maic.png';
  
  $image1var = array(
    'path' => $vars['img1'],
    'alt' => $vars['slide1_title'],
    'title' => $vars['slide1_desc'],
    'attributes' => array('class' => 'slide-img'),
  );
  $vars['slideimage1'] = theme('image', $image1var);
  $image2var = array(
    'path' => $vars['img2'],
    'alt' => $vars['slide2_title'],
    'title' => $vars['slide2_desc'],
    'attributes' => array('class' => 'slide-img'),
  );
  $vars['slideimage2'] = theme('image', $image2var);
  $image3var = array(
    'path' => $vars['img3'],
    'alt' => $vars['slide3_title'],
    'title' => $vars['slide3_desc'],
    'attributes' => array('class' => 'slide-img'),
  );
  $vars['slideimage3'] = theme('image', $image3var);
  
  $vars['logo'] = base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') . '/images/logo/logo.jpg';
  $logovar = array(
    'path' => $vars['logo'],
    'attributes' => array('class' => 'img-responsive'),
  );
  $vars['sitelogo'] = theme('image', $logovar);
  
  
}
