<?php
/**
 * @file
 * Bluez theme implementation to display a single Drupal page.
 *
 * Available variables:
 *
 * General utility variables:
 * - $base_path: The base URL path of the Drupal installation. At the very
 *   least, this will always default to /.
 * - $directory: The directory the template is located in, e.g. modules/system
 *   or themes/garland.
 * - $is_front: TRUE if the current page is the front page.
 * - $logged_in: TRUE if the user is registered and signed in.
 * - $is_admin: TRUE if the user has permission to access administration pages.
 *
 * Site identity:
 * - $front_page: The URL of the front page. Use this instead of $base_path,
 *   when linking to the front page. This includes the language domain or
 *   prefix.
 * - $logo: The path to the logo image, as defined in theme configuration.
 * - $site_name: The name of the site, empty when display has been disabled
 *   in theme settings.
 * - $site_slogan: The slogan of the site, empty when display has been disabled
 *   in theme settings.
 *
 * Navigation:
 * - $main_menu (array): An array containing the Main menu links for the
 *   site, if they have been configured.
 * - $secondary_menu (array): An array containing the Secondary menu links for
 *   the site, if they have been configured.
 * - $breadcrumb: The breadcrumb trail for the current page.
 *
 * Page content (in order of occurrence in the default page.tpl.php):
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title: The page title, for use in the actual HTML content.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 * - $messages: HTML for status and error messages. Should be displayed
 *   prominently.
 * - $tabs (array): Tabs linking to any sub-pages beneath the current page
 *   (e.g., the view and edit tabs when displaying a node).
 * - $action_links (array): Actions local to the page, such as 'Add menu' on the
 *   menu administration interface.
 * - $feed_icons: A string of all feed icons for the current page.
 * - $node: The node object, if there is an automatically-loaded node
 *   associated with the page, and the node ID is the second argument
 *   in the page's path (e.g. node/12345 and node/12345/revisions, but not
 *   comment/reply/12345).
 *
 * Regions:
 * - $page['help']: Dynamic help text, mostly for admin pages.
 * - $page['header']: Items for Header Regions (Inner Pages Only).
 * - $page['content_top']: Items for Content Top Regions (Inner Pages Only).
 * - $page['content']: The main content of the current page.
 * - $page['sidebar_first']: Items for the first sidebar (Right Side Only).
 * - $page['bottom']: Items for the Bottom region.
 * - $page['footer']: Items for the footer region.
 *
 * @see template_preprocess()
 * @see template_preprocess_page()
 * @see template_process()
 */
?>
<script>
(function($) {
    $(document).ready(function(){



	
if ($('#block-search-form .form-item input').val() != ""){
	$('#block-search-form .form-item label').css('z-index', '-1');
}

$("#block-search-form .form-item input").focusin(function() {
    $('#block-search-form .form-item label').css('z-index', '-1');
}).focusout(function() {
	if ($('#block-search-form .form-item input').val() != ""){
		$('#block-search-form .form-item label').css('z-index', '-1');
	} else {
		$('#block-search-form .form-item label').css('z-index', '');
	}
});

$(document).ready(function() {

		$('[data-toggle="tooltip"]').tooltip(); 
		$(window).on("keydown", this, function (event) {
			if (event.keyCode == 116) {
				Cookies.remove('style');
			}
		});
		var plus = 0;
		$('.font-basic').click(function() {
			$('p, span, h1, h2, h3, h4, h5:not(".rank-value"), h6, ul, li, td, th').removeAttr('style');
			plus=0;
		});
		$('.font-plus').click(function() {
			$('p, span, h1, h2, h3, h4, h5:not(".rank-value"), h6, ul, li, td, th').removeAttr('style');
			$('p, .section span, h1, h2, h3, h4, h5:not(".rank-value"), h6, ul, li, td, th').css("font-size", function() {
				plus=plus+1;
				return parseInt($(this).css('font-size')) + 3 + 'px';		
			});
		});
		$('.font-plus-plus').click(function() {
			$('p,  span, h1, h2, h3, h4, h5:not(".rank-value"), h6, ul, li, td, th').removeAttr('style');
			$('p, .section span, h1, h2, h3, h4, h5:not(".rank-value"), h6, ul, li, td, th').css("font-size", function() {
				
				return parseInt($(this).css('font-size')) + 6 + 'px';		
			});
		
		});
		$('.contrast-1').click(function() {
			$('.rank-ico').attr('src','/img/rank.png');
			$('.visible-regular').show();
			$('.visible-contrast').hide();
			$('#contrast-style').remove();
			Cookies.set('style', '1');
		});
		$('.contrast-2').click(function() {
			$('.rank-ico').attr('src','/img/rank-white.png');
			$('.visible-contrast').show();
			$('.visible-regular').hide();
			$('#contrast-style').remove();
			$('head').append('<link id="contrast-style" rel="stylesheet" href="<?php print base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') ?>/css/contrast-2.css" type="text/css" />');
			Cookies.set('style', '2');
		});
		$('.contrast-3').click(function() {
			$('.rank-ico').attr('src','/img/rank.png');
			$('.visible-contrast').show();
			$('.visible-regular').hide();
			$('#contrast-style').remove();
			$('head').append('<link id="contrast-style" rel="stylesheet" href="<?php print base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') ?>/css/contrast-3.css" type="text/css" />');
			Cookies.set('style', '3');
		});
		$('.contrast-4').click(function() {
			$('.rank-ico').attr('src','/img/rank-yellow.png');
			$('.visible-contrast').show();
			$('.visible-regular').hide();
			$('#contrast-style').remove();
			$('head').append('<link id="contrast-style" rel="stylesheet" href="<?php print base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') ?>/css/contrast-4.css" type="text/css" />');
			Cookies.set('style', '4');
		});
		
		var style = Cookies.get('style');
		if(style == 1){
			$('#contrast-style').remove();
			$('.rank-ico').attr('src','/img/rank.png');
		}
		else if(style == 2){
			$('.rank-ico').attr('src','/img/rank-white.png');
			$('head').append('<link id="contrast-style" rel="stylesheet" href="<?php print base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') ?>/css/contrast-2.css" type="text/css" />');
		}
		else if(style == 3){
			$('.rank-ico').attr('src','/img/rank.png');
			$('head').append('<link id="contrast-style" rel="stylesheet" href="<?php print base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') ?>/css/contrast-3.css" type="text/css" />');
		}
		else if(style == 4){
			$('.rank-ico').attr('src','/img/rank-yellow.png');
			$('head').append('<link id="contrast-style" rel="stylesheet" href="<?php print base_path() . drupal_get_path('theme', 'szablon_pwd_t3_1') ?>/css/contrast-4.css" type="text/css" />');
		}
		
		
	});

});
})(jQuery)
</script>
<div id="wrapper">
<div data-spy="affix" data-offset-top="60" data-offset-bottom="200" style="width:100%;background:white!important;z-index:1;"><div style="background-color:white!important;" class="container">
<div class="pull-left" style="background-color:white!important;">
 <?php print $pwdlogo; ?>
 </div>
<div class="icons" style="background-color:white!important;">
	<span class="font font-basic" style="color:black!important; background-color:white!important;" title="Podstawowy rozmiar tekstu">
	A
	</span>
	<span class="font font-plus" style="color:black!important; background-color:white!important;" title="Powiększ tekst o 50%">
	A<em>+</em>
	</span>
	<span class="font font-plus-plus" style="color:black!important; background-color:white!important;" title="Powiększ tekst o 100%">
	A<em>++</em>
	</span>
	
	<span class="contrast contrast-1" style="color:black!important; background-color:white!important;" title="Podstawowy kontrast">
	K
	</span>
	<span class="contrast contrast-2" style="color:white!important; background-color:#000!important;" title="Biały tekst na czarnym tle">
	K
	</span>
	<span class="contrast contrast-3" style="color:black!important; background-color:#ffff00!important;" title="Czarny tekst na źółtym tle">
	K
	</span>
	<span class="contrast contrast-4" style="color:#ffff00!important; background-color:#000!important;" title="Żółty tekst na czarnym tle">
	K
	</span>
</div>
</div></div>
<div class="clear"></div>      
 <!-- Header Starts -->
  <div id="header" class="clearfix">
    <?php /*if ($logo || $site_slogan): ?>
      <div id="logo_slogan_wrapper">
        <!-- logo START -->
        <?php if ($logo): ?>
          <div id="logo">
            <a href="<?php print $front_page; ?>" title="<?php print t('Home'); ?>"><img src="<?php print $logo; ?>" alt="<?php print t('Home'); ?>" /></a>
          </div>
        <?php endif; ?>
        <!-- logo Ends -->
        
        <!-- site slogan Starts -->
        <?php if ($site_slogan): ?>
          <div id="sitename">
            <p><?php print $site_slogan; ?></p><!--site slogan-->
          </div>
        <?php endif; ?>
        <!-- site slogan Ends -->
      </div>
    <?php endif;*/ ?>
	<?php print $sitelogo; ?>
    <!-- navigation START -->
	<nav class="navbar navbar-default">
		<div class="container-fluid">
			<!-- Brand and toggle get grouped for better mobile display -->
			<div class="navbar-header">
			  <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
				<span class="sr-only">Pokaż/Ukryj nawigacje</span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
				<span class="icon-bar"></span>
			  </button>
			</div>
		</div>
		<div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
			<?php print drupal_render($main_menu_tree); ?>
			<div id="top-triangle"></div>
			<div id="bottom-triangle"></div>
			<?php if ($page['header']): ?>
				<div class="col-md-3 nav-search-box">
					<?php print render($page['header']); ?>
				</div>
			<?php endif; ?>
			<!-- socialbar Starts -->
			<?php if ($display): ?>
			<div id="socialbar">
			<ul class="social">
			<?php $options['attributes'] = array('target' => '_blank'); ?>
			<?php if ($facebook): ?><li class="fb"><a href="<?php print $facebook; ?>" target="_blank" class="fa fa-facebook-square"></a></li> <?php endif; ?>
			<?php if ($twitter): ?><li class="tw"><a href="<?php print $twitter; ?>" target="_blank" class="fa fa-twitter"></a></li> <?php endif; ?>
			<?php if ($linkedin): ?><li class="ln"><a href="<?php print $linkedin; ?>" target="_blank" class="fa fa-instagram"></a></li> <?php endif; ?>
			</ul>
			</div>
			<?php endif; ?>
			<!-- socialbar Ends -->
		</div>
	</nav>

  </div>
  <!-- Header Ends -->

  
  <!-- Header Ends -->
  <div class="container padding-none">
  <div id="extra">
   
    <?php print $messages; ?>
  </div>
  <div class="clear"></div>
  
  <div id="main">
	<div class="col-md-3 padding-none">
	<?php if ($page['sidebar_first']): ?>
      <div id="sidebar" class="sidebar clearfix">
        <?php print render($page['sidebar_first']); ?>
      </div>  <!-- /#sidebar-first -->
    <?php endif; ?>
	<?php if ($column_dis == 1): ?>
			<div class="col-md-12 link-group padding-none">
			<a href="<?php print $link1_href ?>" target="_blank"><img src="<?php print $link1_img; ?>" alt="<?php print $link1_href ?>"></a>
			<a href="<?php print $link2_href ?>" target="_blank"><img src="<?php print $link2_img; ?>" alt="<?php print $link2_href ?>"></a>
			<a href="<?php print $link3_href ?>" target="_blank"><img src="<?php print $link3_img; ?>" alt="<?php print $link3_href ?>"></a>
			</div>
			<?php endif; ?>
	</div>
	<div class="col-md-9">
	<div class="col-md-12  bip">
		<div class="col-md-6">
			<a href="<?php print $link4_href ?>" target="_blank"><img src="<?php print $link4_img; ?>" alt="<?php print $link4_title; ?>"></a>
			<a href="<?php print $link4_href ?>" target="_blank"><?php print $link4_title; ?></a>
			<p><?php print $link4_desc; ?></p>
		</div>
		<div class="col-md-6">
			<a href="<?php print $link5_href ?>" target="_blank"><img src="<?php print $link5_img; ?>" alt="<?php print $link5_title; ?>"></a>
			<a href="<?php print $link5_href ?>" target="_blank"><?php print $link5_title; ?></a>
			<p><?php print $link5_desc; ?></p>
		</div>
	</div>
	<div class="clear"></div>
    <div id="post-content">
      <?php if ($page['content_top']): ?><div id="content_top"><?php print render($page['content_top']); ?></div><?php endif; ?>
      <?php print render($title_prefix); ?>
      <?php if ($title): ?><h1 class="page-title"><?php print $title; ?></h1><?php endif; ?>
      <?php print render($title_suffix); ?>
      <?php if (!empty($tabs['#primary'])): ?><div class="tabs-wrapper clearfix"><?php print render($tabs); ?></div><?php endif; ?>
      <?php print render($page['help']); ?>
      <?php if ($action_links): ?><ul class="action-links"><?php print render($action_links); ?></ul><?php endif; ?>
      <?php print render($page['content']); ?>
    </div> <!-- /#main -->
    </div>
  </div>
  </div></div><div class="clear"></div>
  
  <!--Footer context Start -->
  <footer>
    <div class="container">
		<div class="row">
			<div class="col-md-7">
				<p>Strona została opracowana w ramach projektu PWD online realizowanego przez Stowarzyszenie Na Rzecz Rozwoju Regionu Dolina Gubra przy wsparciu Ministerstwa Administracji i Cyfryzacji</p>
			</div>
			<div class="col-md-5">	
				<img src="<?php print $foot2; ?>" alt="Ministerstwo Administracji i Cyfryzacji" class="img-responsive pull-right maic">
				<img src="<?php print $foot1; ?>" class="img-responsive pull-right" alt="Dolina Gubra">
			</div>
		</div>
    </div>
</footer>
  <!--Footer context Ends -->
  <div class="clear"></div>
</div>
